#ifndef NV_CORE_H
#error "Do not include this file directly."
#endif

// Function linkage
#define DLL_IMPORT	__declspec(dllimport)
#define DLL_EXPORT	__declspec(dllexport)
#define DLL_EXPORT_CLASS DLL_EXPORT

// Function calling modes
#define NV_CDECL		__cdecl
#define NV_STDCALL		__stdcall
#define NV_FASTCALL		__fastcall
#define NV_FORCEINLINE	__forceinline

#define NV_PURE
#define NV_CONST

// Set standard function names.
#define snprintf _snprintf
#define vsnprintf _vsnprintf
#define vsscanf _vsscanf
#define chdir _chdir
#define getcwd _getcwd 

#define va_copy(a, b)	a = b

#if !defined restrict
#define restrict
#endif

#if !defined __attribute__
#define __attribute__(X)
#endif

#if !defined __FUNC__
#define __FUNC__	__FUNCTION__ 
#endif


// Type definitions
typedef unsigned char		uint8;
typedef signed char			int8;

typedef unsigned short		uint16;
typedef signed short		int16;

typedef unsigned int		uint32;
typedef signed int			int32;

typedef unsigned __int64	uint64;
typedef signed __int64		int64;

// Aliases
typedef uint32				uint;


// Unwanted VC++ warnings to disable.
#pragma warning(disable : 4244)		// conversion to float, possible loss of data
#pragma warning(disable : 4245)		// conversion from 'enum ' to 'unsigned long', signed/unsigned mismatch
#pragma warning(disable : 4100)		// unreferenced formal parameter
#pragma warning(disable : 4514)		// unreferenced inline function has been removed
#pragma warning(disable : 4710)		// inline function not expanded
#pragma warning(disable : 4127)		// Conditional expression is constant
#pragma warning(disable : 4305)		// truncation from 'const double' to 'float'
#pragma warning(disable : 4505)		// unreferenced local function has been removed

//#pragma warning(disable : 4699)	// creating precompiled header
//#pragma warning(disable : 4201)	// nonstandard extension used : nameless struct/union
#pragma warning(disable : 4702)		// unreachable code in inline expanded function
#pragma warning(disable : 4711)		// function selected for automatic inlining
#pragma warning(disable : 4725)		// Pentium fdiv bug

//#pragma warning(disable : 4512)	// assignment operator could not be generated
//#pragma warning(disable : 4530)	// C++ exception handler used, but unwind semantics are not enabled
//#pragma warning(disable : 4238)	// nonstandard extension used : class rvalue used as lvalue
//#pragma warning(disable : 4251)	// needs to have dll-interface to be used by clients of class 'ULinker'
//#pragma warning(disable : 4275)	// non dll-interface class used as base for dll-interface class

//#pragma warning(disable : 4511)	// copy constructor could not be generated
//#pragma warning(disable : 4284)	// return type is not a UDT or reference to a UDT
//#pragma warning(disable : 4355)	// this used in base initializer list
//#pragma warning(disable : 4097)	// typedef-name '' used as synonym for class-name ''
//#pragma warning(disable : 4291)	// typedef-name '' used as synonym for class-name ''

#pragma warning(disable : 4345)		// behavior change: an object of POD type constructed with an initializer of the form () will be default-initialized

#pragma warning(disable : 4786)		// Identifier was truncated and cannot be debugged.

//#pragma warning(disable : 4996)		// function was declared deprecated.
//#pragma warning(disable : 4146)		// unary minus operator applied to unsigned type, result still unsigned

#pragma warning(disable : 4675)		// resolved overload was found by argument-dependent lookup

